#
# $Id: procs.sh,v 1.6 2006/02/22 21:17:51 rauch Exp $
#
# Testing infrastructure.
#
BIN=../bin
status=0

# Default cleanup function.
cleanup() { true; }
#
trap 'cleanup' HUP INT QUIT TERM


# Display results of a test.
# $1 = test name
result() {
  if [ $status -eq 0 ]; then res=passed; else res=FAILED; setfail; fi
  echo " "
  echo "$1 test $res."
  echo " "
  status=0
}

# Set failure indicator.
setfail() { touch failures; }

# Display test banner
# $1 = test description
testing() {
  echo " "
  echo "-------------------------------------------------"
  echo "Testing $1..."
  echo "-------------------------------------------------"
}

# Run a program and report if it fails.
# $1 = program name; $2 ... = program arguments
tryexec() {
  if [ "`dirname $1`" = "$BIN" -a -n "$VALGRIND" ]; then
    VG="$VALGRIND --log-file=valgrind.`basename $1`"
  else
    VG=""
  fi

  if $VG $*; then
    true
  else
    echo "Execution of "`basename $1`" failed!" >&2
    status=1
    false
  fi
}
