#ifndef HNBODY_OUTPUT_H
#define HNBODY_OUTPUT_H
/**
  \file

  $Id: output.h,v 1.8 2004/02/04 23:19:15 rauch Exp $

  \author Kevin P. Rauch

  \brief Facilities to manipulate \hnb output files.

*/
#include "hnbody/opts.h"

#ifdef __cplusplus
extern "C" {
namespace HNBODY {
#endif


/** \brief Magic number identifying \hnb output files (think 1-800-HNBODY). */
#define HNB_MAGIC 462639


/** \brief Output file header data structure. */
typedef struct hnb_header_struct {
  double G, c, M, epoch, tinit, stepsize, rate, offset[HNB_ORDER_MAX];
  int magic, id, size, ncol, ctype[HNB_ORDER_MAX];
  hnb_class_t fclass;
  hnb_format_t format;
  hnb_coord_t coord;
} hnb_header_t;


DLLSPEC extern void
  hnb_fill_header(hnb_header_t *h, hnb_class_t fclass, hnb_format_t format,
    hnb_coord_t coord, double epoch, double G, double c, double M,
    double E0, const double L0[], double tinit, double stepsize, double rate,
    int id, int digits, const double offset[],
    const hnb_option_tag order[], int ncol);

DLLSPEC extern size_t
  hnb_read_file(double *ddata[], float *fdata[], size_t *nalloc, 
      size_t nkeep, size_t nrec, size_t nresv, int raw, 
      const hnb_header_t *h, FILE *f),
  hnb_write_file(double *const ddata[], float *const fdata[], size_t nrec,
      int header, int raw, const hnb_header_t *h, FILE *f);

DLLSPEC extern int
  hnb_read_dataline(double data[], hnb_format_t format, int ncol, int size,
      const double offset[], FILE *f),
  hnb_read_header(hnb_header_t *h, FILE *f),
  hnb_seek_file(size_t rec, FILE *f),
  hnb_tag2ctype(hnb_option_tag tag),
  hnb_trim_file(const char *datafile, size_t nrec),
  hnb_write_binary(const double data[], int nelem, int dprec, FILE *f),
  hnb_write_dataline(const double data[], hnb_class_t fclass, 
     hnb_format_t format, int ncol, int digits, const double offset[], FILE *f),
  hnb_write_header(const hnb_header_t *h, FILE *f),
  hnb_write_text(const double data[], int nelem, int digits, FILE *f);

DLLSPEC extern hnb_option_tag
  hnb_ctype2tag(int ctype);

DLLSPEC extern FILE
  *hnb_fopen(const char *file, const char *mode);

#ifdef __cplusplus
}  // namespace HNBODY
}  // extern "C"
#endif

#endif  /* HNBODY_OUTPUT_H */
