#ifndef HNBODY_ERRORS_H
#define HNBODY_ERRORS_H
/**
  \file

  $Id: errors.h,v 1.6 2004/01/30 22:54:06 rauch Exp $

  \author Kevin P. Rauch

  \brief Macros for error message generation and controlled termination.

*/
#include <errno.h>
#include <float.h>
#include <limits.h>

#include <mutils/platform.h>

#ifdef __cplusplus
extern "C" {
namespace HNBODY {
#endif


DLLSPEC extern void
  hnb_panic(int err, const char *msg, const char *func, const char *src);

#define panic(err, msg, func, src) do { \
    if (err) hnb_panic(errno, msg, func, src); \
  } while (0)

#define panicn(err, msg, func, src) do { \
    int error=err; \
    if (error) hnb_panic(error, msg, func, src); \
  } while (0)


static const double invalid_dbl = -21.12e-300;
static const int    invalid_int =  INT_MIN+1984;


#ifdef __cplusplus
}  // namespace HNBODY
}  // extern "C"
#endif

#endif  /* HNBODY_ERRORS_H */
